/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import com.talpie.linker.ClientListeners;
import com.talpie.linker.DataSocketClient;
import com.talpie.linker.Message;
import com.talpie.linker.TransferStats;
import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;

public final class ClientStatsListener
implements ClientListeners.ControlMessage,
ClientListeners.DataMessage,
ClientListeners.Progress {
    private final TransferStats stats = new TransferStats();
    private final ConcurrentHashMap<String, Long> txMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> rxMap = new ConcurrentHashMap();

    private static String routeOf(Message m) {
        return m != null ? m.getRoute() : "";
    }

    @Override
    public Message onRequest(Object c, Timestamp ts, Message m) {
        this.stats.onMsgRx(ClientStatsListener.routeOf(m));
        return null;
    }

    @Override
    public Message onResponse(Object c, Timestamp ts, Message m) {
        this.stats.onMsgRx(ClientStatsListener.routeOf(m));
        return null;
    }

    @Override
    public Message onRequest(Object c, Timestamp ts, DataSocketClient ds, Message m) {
        this.stats.onMsgRx(ClientStatsListener.routeOf(m));
        return null;
    }

    @Override
    public Message onResponse(Object c, Timestamp ts, DataSocketClient ds, Message m) {
        this.stats.onMsgRx(ClientStatsListener.routeOf(m));
        return null;
    }

    @Override
    public void onProgressTransmitting(Object c, Timestamp ts, Message m, long sent, long total, int pct) {
        long prev = this.txMap.getOrDefault(m.getMessageId(), 0L);
        long delta = Math.max(0L, sent - prev);
        if (delta > 0L) {
            this.stats.onBytesTx(ClientStatsListener.routeOf(m), delta, true);
            this.txMap.put(m.getMessageId(), sent);
        }
        if (sent >= total) {
            this.txMap.remove(m.getMessageId());
        }
    }

    @Override
    public void onProgressReceiving(Object c, Timestamp ts, Message m, long rec, long total, int pct) {
        long prev = this.rxMap.getOrDefault(m.getMessageId(), 0L);
        long delta = Math.max(0L, rec - prev);
        if (delta > 0L) {
            this.stats.onBytesRx(ClientStatsListener.routeOf(m), delta, true);
            this.rxMap.put(m.getMessageId(), rec);
        }
        if (rec >= total) {
            this.rxMap.remove(m.getMessageId());
        }
    }

    @Override
    public void onProgressDataTransmitting(Object c, Timestamp ts, DataSocketClient ds, Message m, long s, long t, int p) {
        this.onProgressTransmitting(c, ts, m, s, t, p);
    }

    @Override
    public void onProgressDataReceiving(Object c, Timestamp ts, DataSocketClient ds, Message m, long r, long t, int p) {
        this.onProgressReceiving(c, ts, m, r, t, p);
    }

    public TransferStats snapshot() {
        return this.stats;
    }

    public void onMsgTx(String route) {
        this.stats.onMsgTx(route);
    }

    public void onMsgRx(String route) {
        this.stats.onMsgRx(route);
    }
}

