/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;

public final class TransferStats {
    private final ConcurrentHashMap<String, Route> perRoute = new ConcurrentHashMap();
    private final Route total = new Route("*");

    private Route r(String route) {
        return this.perRoute.computeIfAbsent(route == null ? "" : route, Route::new);
    }

    public void onMsgTx(String route) {
        this.r((String)route).msgTx.increment();
        this.total.msgTx.increment();
        this.r(route).touch();
    }

    public void onMsgRx(String route) {
        this.r((String)route).msgRx.increment();
        this.total.msgRx.increment();
        this.r(route).touch();
    }

    public void onBytesTx(String route, long deltaBytes, boolean chunked) {
        if (deltaBytes <= 0L) {
            return;
        }
        this.r((String)route).bytesTx.add(deltaBytes);
        this.total.bytesTx.add(deltaBytes);
        if (chunked) {
            this.r((String)route).chunksTx.increment();
            this.total.chunksTx.increment();
        }
        this.r(route).touch();
    }

    public void onBytesRx(String route, long deltaBytes, boolean chunked) {
        if (deltaBytes <= 0L) {
            return;
        }
        this.r((String)route).bytesRx.add(deltaBytes);
        this.total.bytesRx.add(deltaBytes);
        if (chunked) {
            this.r((String)route).chunksRx.increment();
            this.total.chunksRx.increment();
        }
        this.r(route).touch();
    }

    public Route totals() {
        return this.total;
    }

    public Map<String, Route> perRoute() {
        return Map.copyOf(this.perRoute);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        Route all = this.totals();
        sb.append("TOTAL *  ").append("msgTx=").append(all.msgTx()).append(" msgRx=").append(all.msgRx()).append(" bytesTx=").append(all.bytesTx()).append(" bytesRx=").append(all.bytesRx()).append('\n');
        this.perRoute().forEach((route, r) -> sb.append("  ").append((String)route).append("  ").append("msgTx=").append(r.msgTx()).append(' ').append("msgRx=").append(r.msgRx()).append(' ').append("bytesTx=").append(r.bytesTx()).append(' ').append("bytesRx=").append(r.bytesRx()).append(' ').append("chunksTx=").append(r.chunksTx()).append(' ').append("chunksRx=").append(r.chunksRx()).append('\n'));
        return sb.toString();
    }

    public static final class Route {
        public final String name;
        private final LongAdder msgTx = new LongAdder();
        private final LongAdder msgRx = new LongAdder();
        private final LongAdder bytesTx = new LongAdder();
        private final LongAdder bytesRx = new LongAdder();
        private final LongAdder chunksTx = new LongAdder();
        private final LongAdder chunksRx = new LongAdder();
        volatile long lastActivity;

        Route(String name) {
            this.name = name;
        }

        void touch() {
            this.lastActivity = System.currentTimeMillis();
        }

        public long msgTx() {
            return this.msgTx.sum();
        }

        public long msgRx() {
            return this.msgRx.sum();
        }

        public long bytesTx() {
            return this.bytesTx.sum();
        }

        public long bytesRx() {
            return this.bytesRx.sum();
        }

        public long chunksTx() {
            return this.chunksTx.sum();
        }

        public long chunksRx() {
            return this.chunksRx.sum();
        }
    }
}

