/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import com.talpie.linker.ClientHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RoomMixer
implements AutoCloseable,
Runnable {
    private static final int FRAME_MS = 25;
    private final int frameBytes;
    private final int frameSamples;
    private final String route;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread thread;
    private final Map<UUID, BlockingQueue<byte[]>> inputs = new ConcurrentHashMap<UUID, BlockingQueue<byte[]>>();
    private final List<Member> members = Collections.synchronizedList(new ArrayList());

    public RoomMixer(String route, int frameBytes) {
        this.route = route;
        this.frameBytes = frameBytes;
        this.frameSamples = frameBytes / 2;
    }

    public void join(ClientHandler ch, UUID senderId) {
        this.members.add(new Member(ch, senderId));
        this.inputs.computeIfAbsent(senderId, k -> new LinkedBlockingQueue(8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(ClientHandler ch) {
        Member toRemove = null;
        List<Member> list = this.members;
        synchronized (list) {
            for (Member m : this.members) {
                if (m.ch != ch) continue;
                toRemove = m;
                break;
            }
            if (toRemove != null) {
                this.members.remove(toRemove);
            }
        }
        if (toRemove != null) {
            this.inputs.remove(toRemove.senderId);
        }
    }

    public BlockingQueue<byte[]> getInput(UUID senderId) {
        return this.inputs.get(senderId);
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.thread = new Thread((Runnable)this, "RoomMixer");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public void close() {
        this.running.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] silence = new byte[this.frameBytes];
        long tickNanos = 25000000L;
        while (this.running.get()) {
            long dt;
            long sleepNs;
            long t0 = System.nanoTime();
            HashMap<UUID, byte[]> frames = new HashMap<UUID, byte[]>();
            Object object = this.inputs.entrySet().iterator();
            while (object.hasNext()) {
                byte[] f;
                Map.Entry<UUID, BlockingQueue<byte[]>> e;
                frames.put(e.getKey(), (f = (byte[])(e = object.next()).getValue().poll()) != null && f.length == this.frameBytes ? f : silence);
            }
            if (!frames.isEmpty()) {
                object = this.members;
                synchronized (object) {
                    for (Member m : this.members) {
                        byte[] out = this.mixMinus(frames, m.senderId);
                        try {
                            m.ch.sendRequest(this.route, out);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            if ((sleepNs = 25000000L - (dt = System.nanoTime() - t0)) <= 0L) continue;
            try {
                Thread.sleep(sleepNs / 1000000L, (int)(sleepNs % 1000000L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private byte[] mixMinus(Map<UUID, byte[]> frames, UUID excludeSender) {
        int N = frames.size() - 1;
        byte[] out = new byte[this.frameBytes];
        if (N <= 0) {
            return out;
        }
        int[] sum = new int[this.frameSamples];
        for (byte[] f : frames.values()) {
            int s = 0;
            for (int i = 0; i < this.frameBytes; i += 2) {
                int sample = f[i] & 0xFF | f[i + 1] << 8;
                int n = s++;
                sum[n] = sum[n] + (short)sample;
            }
        }
        byte[] self = frames.get(excludeSender);
        int i = 0;
        int s = 0;
        while (i < this.frameBytes) {
            int v = sum[s];
            if (self != null) {
                int me = self[i] & 0xFF | self[i + 1] << 8;
                v -= (short)me;
            }
            if ((v /= N) > Short.MAX_VALUE) {
                v = Short.MAX_VALUE;
            }
            if (v < Short.MIN_VALUE) {
                v = Short.MIN_VALUE;
            }
            out[i] = (byte)(v & 0xFF);
            out[i + 1] = (byte)(v >> 8 & 0xFF);
            i += 2;
            ++s;
        }
        return out;
    }

    private static final class Member {
        final ClientHandler ch;
        final UUID senderId;

        Member(ClientHandler ch, UUID senderId) {
            this.ch = ch;
            this.senderId = senderId;
        }
    }
}

